package com.example.personnelmanager.entity;


import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupGetOne;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "legal_entity")
@ToString(exclude = {"enterprise","organizationNodes","organizationNodes"})
@EntityListeners(AuditingEntityListener.class)
@Where(clause = "delete_tag = 0")
public class LegalEntity {

  @Max(value = 0,groups = {GroupSave.class} )
  @NotNull(groups = {GroupDelete.class, GroupGetOne.class, GroupUpdate.class})
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "legal_entity_id",columnDefinition = "bigint comment '企业编号' ")
  private Long legalEntityId;

  @NotNull(groups = {GroupSave.class,GroupUpdate.class},message = "法律实体名称不能为空")
  @Column(name = "legal_entity_name",nullable = false,columnDefinition = "varchar(128) comment '法律实体名称' ")
  private String legalEntityName;

  @NotNull(groups = {GroupSave.class,GroupUpdate.class},message = "社会信用代码不能为空")
  @Column(name = "social_credit_code",nullable = false,columnDefinition = "varchar(18) comment '社会信用代码' ")
  private String socialCreditCode;

  @Column(name = "tax_declaration_area",columnDefinition = "varchar(255) comment '报税区域' ")
  private String taxDeclarationArea;

  @Column(name = "address",columnDefinition = "varchar(255) comment '所在地址' ")
  private String address;

  @Column(name = "phone",columnDefinition = "varchar(16) comment '电话' ")
  private String phone;

  @Column(name = "bank",columnDefinition = "varchar(64) comment '开户银行' ")
  private String bank;

  @Column(name = "bank_number",columnDefinition = "varchar(128) comment '银行账号' ")
  private String bankNumber;

  @Lob
  @Column(name = "remark",columnDefinition = "text comment '备注' ")
  private String remark;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记'")
  private int deleteTag;

  @CreatedDate
  @Column(name = "create_time",nullable = false,columnDefinition = " datetime comment '删除标记（0为正常，1为被删除）'")
  private Instant createTime;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @JsonIgnoreProperties(value = {"legalEntities","titles","educationalExperiences","duties","contracts","legalEntities","certificates","organizationNodes","workPlaces","posts","peoples","users"})
  @ManyToOne(cascade={CascadeType.REFRESH})
  @JoinColumn(name = "enterprise_id",nullable = false,columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "legalEntity")
  private List<OrganizationNode> organizationNodes;


}
