package com.example.personnelmanager.entity;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class TitleContent
 * @packageName com.example.personnelmanager.entity
 * @data 2020/5/18
 **/
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "title_comtemt")
@Data
@EntityListeners(AuditingEntityListener.class)
@Where(clause = "delete_tag = 0")
public class TitleContent {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "title_content_id",columnDefinition = "bigint comment '职称内容编号'")
    private Long titleId;

    @Column(name = "title_level",columnDefinition = "varchar(16) comment '职称等级'")
    private String titleLevel;

    @Column(name = "title_type",columnDefinition = "varchar(32) comment '职称类型'")
    private String titleType;

    @Column(name = "title_name",columnDefinition = "varchar(64) comment '职称名称'")
    private String titleName;


}
