package com.example.personnelmanager.entity;


import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.data.annotation.CreatedDate;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "user")
@ToString(exclude = {"enterprise"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class User {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "user_id",columnDefinition = "bigint comment '用户编号'")
  private Long userId;

  @Column(name = "username",unique = true,columnDefinition = "varchar(64) comment '用户名' ")
  private String username;

  @Column(name = "name",unique = true,columnDefinition = "varchar(64) comment '用户名字' ")
  private String name;


  @NotNull(groups = {GroupSave.class})
  @Column(name = "password",nullable = false,columnDefinition = "varchar(255) comment '密码'")
  private String password;

  @CreatedDate
  @Column(name = "create_date",nullable = false,columnDefinition = "datetime comment '创建时间'")
  private Instant createDate;

  @Column(name = "phone",columnDefinition = "varchar(16) comment '手机号码'")
  private String phone;

  @Column(name = "administrator",columnDefinition = "bool comment '是否超级管理员'")
  private boolean administrator;

  @Column(name = "delete_tag",columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）'")
  private int deleteTag;

  @NotNull(groups = {GroupSave.class},message = "无所属企业")
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;


}
