package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.ContractRepository;
import com.example.personnelmanager.entity.Contract;
import com.example.personnelmanager.entity.People;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.service.ContractService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ContractServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/15
 **/
@Service
public class ContractServiceImpl implements ContractService {

    @Autowired
    ContractRepository contractRepository;

    @Override
    public Contract addEntity(Contract contract) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        contract.setEnterprise(userDetails.getEnterprise());
        Contract save = contractRepository.save(contract);
        return save;
    }

    @Override
    public Page getPage(Contract contract, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder and = Specifications.<Contract>and();
        and.eq("people.peopleId",contract.getPeople().getPeopleId());
        and.eq("enterprise.enterpriseId", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<Contract> specification = and.build();
        Page<Contract> all = contractRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public List<Contract> getList(Contract contract) {
        return null;
    }

    @Override
    public Contract update(Contract contract) {
        Contract after = contractRepository.save(contract);
        return after;
    }

    @Override
    public Contract getOne(Long id) {
        Optional<Contract> byId = contractRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的合同不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Contract> byId = contractRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的合同");
        }
        Contract contract = byId.get();
        contract.setDeleteTag(1);
        contractRepository.save(contract);
        return true;
    }

    @Override
    public Specification<Contract> specificationBuild(Contract contract) {
        return null;
    }
}
