package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.EducationalExperienceRepository;
import com.example.personnelmanager.entity.EducationalExperience;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.service.EducationalExperienceService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class EducationalExperienceServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/20
 **/

@Service
public class EducationalExperienceServiceImpl implements EducationalExperienceService {

    @Autowired
    EducationalExperienceRepository educationalExperienceRepository;

    @Override
    public EducationalExperience addEntity(EducationalExperience educationalExperience) {
        UserDetail userDetails =  AuthenticationUtils.getAuthentication();
        EducationalExperience save = educationalExperienceRepository.save(educationalExperience);
        return save;
    }

    @Override
    public Page getPage(EducationalExperience educationalExperience, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder<EducationalExperience> and = Specifications.and();
        and.eq("enterprise.enterpriseId", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<EducationalExperience> specification = and.build();
        Page<EducationalExperience> all = educationalExperienceRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public List<EducationalExperience> getList(EducationalExperience educationalExperience) {
        return null;
    }

    @Override
    public EducationalExperience update(EducationalExperience educationalExperience) {
        EducationalExperience after = educationalExperienceRepository.save(educationalExperience);
        return after;
    }

    @Override
    public EducationalExperience getOne(Long id) {
        Optional<EducationalExperience> byId = educationalExperienceRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的教育经历不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<EducationalExperience> byId = educationalExperienceRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的教育经历");
        }
        EducationalExperience educationalExperience = byId.get();
        educationalExperience.setDeleteTag(1);
        educationalExperienceRepository.save(educationalExperience);
        return true;
    }

    @Override
    public Specification<EducationalExperience> specificationBuild(EducationalExperience educationalExperience) {
        return null;
    }
}
