package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.PostRepository;
import com.example.personnelmanager.entity.OrganizationNode;
import com.example.personnelmanager.entity.Post;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.entity.vo.PostVo;
import com.example.personnelmanager.service.OrganizationNodeService;
import com.example.personnelmanager.service.PostService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntityService
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/13
 **/

@Service
public class PostServiceImpl implements PostService {

    @Autowired
    PostRepository postRepository;

    @Autowired
    OrganizationNodeService organizationNodeService;

    @Override
    public Post addEntity(Post post) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        OrganizationNode one = organizationNodeService.getOne(post.getOrganizationNode().getNodeId());
        if (!one.getEnterprise().getEnterpriseId().equals(userDetails.getEnterprise().getEnterpriseId())) {
            throw new UsernameNotFoundException("当前登录用户无权限操作该父节点");
        }
        post.setNodeLevel(one.getNodeLevel());
        post.setEnterprise(userDetails.getEnterprise());
        Post save = postRepository.save(post);
        return save;
    }

    @Override
    public Page getPage(Post post, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        if (post != null) {
            if (!StringUtils.isEmpty(post.getPostName())&&post.getOrganizationNode()!=null&&post.getOrganizationNode().getNodeId()>0){
                return postRepository.findPostTreeVoPageableByEnterpriseIdAndOrganizationNodeAndPostName(userDetails.getEnterprise().getEnterpriseId(),post.getOrganizationNode().getNodeId(),post.getPostName(), pageable);
            }
            if (!StringUtils.isEmpty(post.getPostName())){
                return postRepository.findPostTreeVoPageableByEnterpriseIdAndPostName(userDetails.getEnterprise().getEnterpriseId(),post.getPostName(), pageable);
            }
            if (post.getOrganizationNode()!=null&&post.getOrganizationNode().getNodeId()>0){
                return postRepository.findPostTreeVoPageableByEnterpriseIdAndOrganizationNode(userDetails.getEnterprise().getEnterpriseId(),post.getOrganizationNode().getNodeId(), pageable);
            }
        }
        return postRepository.findPostTreeVoPageableByEnterpriseId(userDetails.getEnterprise().getEnterpriseId(), pageable);
    }

    @Override
    public List<Post> getList(Post post) {
        return null;
    }

    @Override
    public Post update(Post post) {
        Post after = postRepository.save(post);
        return after;
    }

    @Override
    public Post getOne(Long id) {
        Optional<Post> byId = postRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的工作地点不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Post> byId = postRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        Post post = byId.get();
        post.setDeleteTag(1);
        postRepository.save(post);
        return true;
    }

    @Override
    public Specification<Post> specificationBuild(Post post) {
        return null;
    }
}
