package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.TitleImageRepository;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.service.TitleImageService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class TitleImageServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/18
 **/
@Service
public class TitleImageServiceImpl implements TitleImageService {

    final TitleImageRepository titleImageRepository;

    public TitleImageServiceImpl(TitleImageRepository titleImageRepository) {
        this.titleImageRepository = titleImageRepository;
    }


    @Override
    public TitleImage addEntity(TitleImage titleImage) {
        return titleImageRepository.save(titleImage);
    }

    @Override
    public Page getPage(TitleImage titleImage, Pageable pageable) {
        Specification<TitleImage> specification = specificationBuild(titleImage);
        return titleImageRepository.findAll(specification, pageable);
    }

    @Override
    public List<TitleImage> getList(TitleImage titleImage) {
        Specification<TitleImage> specification = specificationBuild(titleImage);
        return titleImageRepository.findAll(specification);
    }

    @Override
    public TitleImage update(TitleImage titleImage) {
        TitleImage after = titleImageRepository.save(titleImage);
        return after;
    }

    @Override
    public TitleImage getOne(Long id) {
        Optional<TitleImage> byId = titleImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的职称图片不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<TitleImage> byId = titleImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        TitleImage titleImage = byId.get();
        titleImage.setDeleteTag(1);
        titleImageRepository.save(titleImage);
        return true;
    }

    @Override
    public Specification<TitleImage> specificationBuild(TitleImage titleImage) {
        PredicateBuilder<TitleImage> and = Specifications.and();
        and.eq("title",titleImage.getTitle().getTitleId());
        and.eq("deleteTag", 0);
        return and.build();
    }

}
