package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.service.UserServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

/**
 * 自定义用户详情Service
 * @author HuangXiahao
 * @version V1.0
 * @class UserDetailsServiceImpl
 * @packageName com.example.personnelmanager.common.config
 * @data 2020/5/20
 **/
@Service
public class UserDetailsServiceImpl implements UserDetailsService {

    @Autowired
    UserServer userServer;

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetail userDetail = userServer.selectByUserName(username);
        if (userDetail==null){
            throw new UsernameNotFoundException("用户名或者密码错误");
        }
        return  userDetail;
    }
}
