package com.example.personnelmanager.common.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.joda.time.DateTime;

import java.security.PrivateKey;
import java.util.Map;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class jwtUtil
 * @packageName com.tykj.support.misc.util
 **/
public class JwtUtil {

    public static String generateToken(Map<String,Object> payloadMap, int expireMinutes, PrivateKey privateKey) {
        return Jwts.builder()
                .setClaims(payloadMap)
                .setExpiration(DateTime.now().plusMinutes(expireMinutes).toDate())
                .signWith(SignatureAlgorithm.RS256, privateKey)
                .compact();
    }

    public static String generateToken(Claims claims, int expireMinutes, PrivateKey privateKey) {
        return Jwts.builder()
                .setClaims(claims)
                .setExpiration(DateTime.now().plusMinutes(expireMinutes).toDate())
                .signWith(SignatureAlgorithm.RS256, privateKey)
                .compact();
    }

}
