package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.entity.vo.pageableVo.EducationalExperiencePageableVo;
import com.example.personnelmanager.service.EducationImageService;
import com.example.personnelmanager.service.EducationalExperienceService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class EducationalExperienceController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/20
 **/

@RestController
@RequestMapping("/api/educationalExperience")
public class EducationalExperienceController {

    /**
     * 图片保存路径
     */
    @Value("${file.imagePath}")
    private String imagesFilePath;

    final EducationalExperienceService educationalExperienceService;

    final EducationImageService educationImageService;

    public EducationalExperienceController(EducationalExperienceService educationalExperienceService, EducationImageService educationImageService) {
        this.educationalExperienceService = educationalExperienceService;
        this.educationImageService = educationImageService;
    }

    @RequestMapping(method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addEducationalExperience(@Validated(GroupSave.class) @RequestBody EducationalExperience educationalExperience) {
        EducationalExperience addEducationalExperience = educationalExperienceService.addEntity(educationalExperience);
        return new ResultObj(addEducationalExperience, addEducationalExperience != null ? "success" : "插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getContractPage(@RequestBody EducationalExperiencePageableVo educationalExperienceVo) {
        return new ResultObj(educationalExperienceService.getPage(educationalExperienceVo.getEducationalExperience(), educationalExperienceVo.getPageable()), "success");
    }

    @RequestMapping(method = RequestMethod.DELETE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj delContract(@NotNull Long educationalExperienceId) {
        return new ResultObj(educationalExperienceService.delete(educationalExperienceId), "success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getContract(@NotNull Long educationalExperienceId) {
        return new ResultObj(educationalExperienceService.getOne(educationalExperienceId), "success");
    }

    @RequestMapping(method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateContract(@Validated(GroupUpdate.class) @RequestBody EducationalExperience educationalExperience) {
        return new ResultObj(educationalExperienceService.update(educationalExperience), "success");
    }

    @RequestMapping(value = "/deleteImage",method = RequestMethod.DELETE)
    public ResultObj delContractImage(@NotNull Long educationalExperienceImageId) {
        return new ResultObj(educationImageService.delete(educationalExperienceImageId), "success");
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public ResultObj addContractImage(@RequestParam("file") MultipartFile file, Long educationalExperienceId) throws IOException {
        if (!file.isEmpty()) {
            EducationImage educationImage = new EducationImage();
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            file.transferTo(new File(imagesFilePath + fileName));
            EducationalExperience educationalExperience = new EducationalExperience();
            educationalExperience.setEducationalId(educationalExperienceId);
            educationImage.setEducationalExperience(educationalExperience);
            educationImage.setUrl("/images/" + fileName);
            educationImageService.addEntity(educationImage);
            return new ResultObj(educationImage, "success");
        } else {
            throw new GlobalException("文件是空的");
        }
    }
}
