package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.entity.vo.PeopleVo;
import com.example.personnelmanager.entity.vo.pageableVo.PeoplePageableVo;
import com.example.personnelmanager.service.CertificateService;
import com.example.personnelmanager.service.PeoplePostService;
import com.example.personnelmanager.service.PeopleService;
import io.swagger.models.auth.In;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.*;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeopleController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/15
 **/
@RestController
@RequestMapping("/api/people")
public class PeopleController {

    private static final String IMAGE_FRONT_KEY = "front";

    private static final String IMAGE_BACK_KEY = "back";

    private static final String ICON_KEY = "icon";

    @Value("${file.imagePath}")
    String imagesFilePath;

    final PeopleService peopleService;

    final CertificateService certificateService;

    @Autowired
    PeoplePostService peoplePostService;

    public PeopleController(PeopleService peopleService, CertificateService certificateService) {
        this.peopleService = peopleService;
        this.certificateService = certificateService;
    }

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addPeople(@Validated(GroupSave.class) @RequestBody People people){
        People addPeople = peopleService.addEntity(people);
        return new ResultObj(addPeople,addPeople!=null?"success":"插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "/excel",method = RequestMethod.POST)
    public ResultObj AddPeopleByExcel() throws IOException {
        HashMap hashMap = new HashMap();
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook("C:\\Users\\admin\\Desktop\\浙江泰源科技有限公司资料整理\\泰源科技人员信息.xlsx");
        XSSFSheet sheetAt = xssfWorkbook.getSheetAt(0);
        for (int i = 0; i < sheetAt.getLastRowNum(); i++) {
            XSSFRow row = sheetAt.getRow(i);
            XSSFCell cellName = row.getCell(0);
            XSSFCell celPhone = row.getCell(2);
            hashMap.put(cellName.getStringCellValue(),celPhone.getStringCellValue());
        }
        File file = new File("G:\\front.sql");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String tempStr;
            boolean flag = false;
            int i = 0;
            People people = new People();
            PeoplePost peoplePost = new PeoplePost();
            while ((tempStr = reader.readLine()) != null) {
                if (tempStr.contains("INSERT")&&tempStr.contains("personnelManager_people_info")){
                    flag = true;
                    i = 0;
                }
                if (tempStr.contains("at")){
                    flag = false;
                }
                if (flag){
                    i++;
                    if (i>=3){
                        tempStr = tempStr.substring(tempStr.indexOf("=")+1);
                        tempStr = tempStr.replaceAll("\'","");
                    }
                    if (i==3){
                        people.setPeopleId(Long.valueOf(tempStr));
                    }
                    if (i==4){
                        people.setName(tempStr);
                        if (hashMap.containsKey(tempStr)){
                            people.setPhone(hashMap.get(tempStr).toString());
                        }
                    }
                    if (i==10){
                        people.setIdCardNumber(tempStr);
                    }
                    if (i==11){
                        if (!tempStr.equals("NULL")){
                            Post post = new Post();
                            post.setPostId(Long.valueOf(tempStr));
                            peoplePost.setPeople(people);
                            peoplePost.setPost(post);
                        }
                    }
                    if (i==13){
                        people.setIcon(tempStr.substring(tempStr.indexOf("/")+1));
                        try {
                            people.setEntryTime(Instant.now());
                            peopleService.addEntity(people);
                            peoplePostService.addEntity(peoplePost);
                        }catch (Exception e){
                            System.out.println("1");
                        }
                    }
                }
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return new ResultObj("成功");
    }




    @RequestMapping(value = "/list",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getPeoplePage(@RequestBody PeoplePageableVo peopleDto){
        return new ResultObj(peopleService.getList(peopleDto),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delPeople(@NotNull Long peopleId){
        return new ResultObj(peopleService.delete(peopleId),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getPeople(@NotNull Long peopleId){
        People one = peopleService.getOne(peopleId);
        return new ResultObj(one,"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updatePeople(@Validated(GroupUpdate.class) @RequestBody People people){
        return new ResultObj(peopleService.update(people),"success");
    }

    @RequestMapping(value = "/leave",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj leave(@Validated(GroupSave.class) @RequestBody LeaveInformation leaveInformation){
        People leave = peopleService.leave(leaveInformation);
        return new ResultObj(leave,"success");
    }

    @RequestMapping(value = "/againEntry",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj againEntry(@Validated(GroupSave.class) @RequestBody AgainEntryInformation againEntryInformation){
        People leave = peopleService.againEntry(againEntryInformation);
        return new ResultObj(leave,"success");
    }

    @RequestMapping(value = "/becomeRegularWorker",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj becomeRegularWorker(@Validated(GroupSave.class) @RequestBody BecomeRegularWorkerInformation becomeRegularWorkerInformation){
        People leave = peopleService.becomeRegularWorker(becomeRegularWorkerInformation);
        return new ResultObj(leave,"success");
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public People addContractImage(@RequestParam("file") MultipartFile file, @NotNull Long peopleId,String type) throws IOException {
        if (!file.isEmpty()) {
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //指定本地存入路径
            file.transferTo(new File(imagesFilePath + fileName));
            if (!StringUtils.isEmpty(type)){
                People one = peopleService.getOne(peopleId);
                if (type.equals(IMAGE_FRONT_KEY)){
                    one.setIdCardFrontUrl("/images/" + fileName);
                }else if (type.equals(IMAGE_BACK_KEY)){
                    one.setIdCardBackUrl("/images/"+fileName);
                }else if (type.equals(ICON_KEY)){
                    one.setIcon("/images/"+fileName);
                }
                peopleService.update(one);
                return one;
            }else {
                throw new GlobalException("请输入证件照片属于哪一面");
            }
        } else {
            throw new GlobalException("文件是空的");
        }
    }

}
