package com.example.personnelmanager.dao;

import com.example.personnelmanager.entity.Post;
import com.example.personnelmanager.entity.vo.PostVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntityDao
 * @packageName com.example.personnelmanager.dao
 * @data 2020/5/13
 **/
public interface PostRepository extends JpaRepository<Post, Long>, JpaSpecificationExecutor {

    @Modifying
    @Query("update Post o set o.deleteTag = 1 where o.organizationNode.nodeId=:nodeId or o.nodeLevel like concat('%.',:nodeId,'.%') ")
    void deletePostByNodeId(Long nodeId);

    @Query(value = "select new com.example.personnelmanager.entity.vo.PostVo(p.postId,p.postName,p.postIntroduction,p.organizationNode,count(ps.people.peopleId)) from " +
            "Post p left join PeoplePost ps on p.postId = ps.post.postId where " +
            "p.enterprise.enterpriseId =:enterpriseId and p.deleteTag=0 and p.organizationNode.nodeId =:organizationNodeId " +
            "GROUP BY  p.postId")
    Page<PostVo> findPostTreeVoPageableByEnterpriseIdAndOrganizationNode(Long enterpriseId,Long organizationNodeId, Pageable pageable);

    @Query(value = "select new com.example.personnelmanager.entity.vo.PostVo(p.postId,p.postName,p.postIntroduction,p.organizationNode,count(ps.people.peopleId)) from " +
            "Post p left join PeoplePost ps on p.postId = ps.post.postId where " +
            "p.enterprise.enterpriseId =:enterpriseId and p.deleteTag=0" +
            "GROUP BY  p.postId")
    Page<PostVo> findPostTreeVoPageableByEnterpriseId(Long enterpriseId, Pageable pageable);

    @Query(value = "select new com.example.personnelmanager.entity.vo.PostVo(p.postId,p.postName,p.postIntroduction,p.organizationNode,count(ps.people.peopleId)) from " +
            "Post p left join PeoplePost ps on p.postId = ps.post.postId where " +
            "p.enterprise.enterpriseId =:enterpriseId and p.deleteTag=0 and p.postName like concat('%',:postName,'%') " +
            "GROUP BY  p.postId")
    Page<PostVo> findPostTreeVoPageableByEnterpriseIdAndPostName(Long enterpriseId,String postName, Pageable pageable);

    @Query(value = "select new com.example.personnelmanager.entity.vo.PostVo(p.postId,p.postName,p.postIntroduction,p.organizationNode,count(ps.people.peopleId)) from " +
            "Post p left join PeoplePost ps on p.postId = ps.post.postId where " +
            "p.enterprise.enterpriseId =:enterpriseId and p.deleteTag=0 and p.organizationNode.nodeId =:organizationNodeId and p.postName like concat('%',:postName,'%') " +
            "GROUP BY  p.postId")
    Page<PostVo> findPostTreeVoPageableByEnterpriseIdAndOrganizationNodeAndPostName(Long enterpriseId,Long organizationNodeId,String postName, Pageable pageable);


}
