package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "contract_image")
@ToString(exclude = {"contract"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
@EntityListeners(AuditingEntityListener.class)
@Where(clause = "delete_tag = 0")
public class ContractImage {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "contract_image_id",columnDefinition = "bigint comment '合同照片编号' ")
  private Long contractImageId;

  @Lob
  @Column(name = "url",columnDefinition = "text comment '照片地址'")
  private String url;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）' ")
  private int deleteTag;

  @CreatedDate
  @Column(name = "create_time",nullable = false,columnDefinition = "datetime comment '创建时间' ")
  private Instant createTime;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
  @JoinColumn(name = "contract_id",nullable = false,columnDefinition = "bigint comment '合同编号'")
  private Contract contract;
}
