package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.AgainEntryInformationRepository;
import com.example.personnelmanager.entity.AgainEntryInformation;
import com.example.personnelmanager.service.AgainEntryInformationService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class AgainEntryInformationServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/29
 **/
@Service
public class AgainEntryInformationServiceImpl implements AgainEntryInformationService {

    @Autowired
    AgainEntryInformationRepository againEntryInformationRepository;

    @Override
    public AgainEntryInformation addEntity(AgainEntryInformation againEntryInformation) {
        return againEntryInformationRepository.save(againEntryInformation);
    }

    @Override
    public Page<AgainEntryInformation> getPage(AgainEntryInformation againEntryInformation, Pageable pageable) {
        Specification<AgainEntryInformation> specification = specificationBuild(againEntryInformation);
        return againEntryInformationRepository.findAll(specification, pageable);
    }

    @Override
    public List<AgainEntryInformation> getList(AgainEntryInformation againEntryInformation) {
        Specification<AgainEntryInformation> specification = specificationBuild(againEntryInformation);
        return againEntryInformationRepository.findAll(specification);
    }

    @Override
    public AgainEntryInformation update(AgainEntryInformation againEntryInformation) {
        return againEntryInformationRepository.save(againEntryInformation);
    }

    @Override
    public AgainEntryInformation getOne(Long id) {
        Optional<AgainEntryInformation> byId = againEntryInformationRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的再入职记录不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<AgainEntryInformation> byId = againEntryInformationRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的再入职记录");
        }
        AgainEntryInformation againEntryInformation = byId.get();
        againEntryInformation.setDeleteTag(1);
        againEntryInformationRepository.save(againEntryInformation);

        return true;
    }

    @Override
    public Specification<AgainEntryInformation> specificationBuild(AgainEntryInformation againEntryInformation) {
        PredicateBuilder<AgainEntryInformation> and = Specifications.and();
        if (againEntryInformation!=null){
            if (againEntryInformation.getPeople()!=null){
                and.eq("people.peopleId","%"+againEntryInformation.getPeople().getPeopleId()+"%");
            }
        }
        and.eq("deleteTag", 0);
        return and.build();
    }
}
