package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.EducationImageRepository;
import com.example.personnelmanager.entity.ContractImage;
import com.example.personnelmanager.entity.EducationImage;
import com.example.personnelmanager.entity.EducationalExperience;
import com.example.personnelmanager.entity.TitleImage;
import com.example.personnelmanager.service.EducationImageService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class EducationImageServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/22
 **/

@Service
public class EducationImageServiceImpl implements EducationImageService {

    @Autowired
    EducationImageRepository educationImageRepository;

    @Override
    public EducationImage addEntity(EducationImage educationImage) {
        EducationImage save = educationImageRepository.save(educationImage);
        return save;
    }

    @Override
    public Page getPage(EducationImage educationImage, Pageable pageable) {
        PredicateBuilder and = Specifications.<EducationImage>and();
        and.eq("educationalExperience.educationalExperienceId",educationImage.getEducationalExperience().getEducationalId());
        and.eq("deleteTag", 0);
        Specification<EducationImage> specification = and.build();
        Page<EducationImage> all = educationImageRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public List<EducationImage> getList(EducationImage educationImage) {
        return null;
    }

    @Override
    public EducationImage update(EducationImage educationImage) {
        EducationImage after = educationImageRepository.save(educationImage);
        return after;
    }

    @Override
    public EducationImage getOne(Long id) {
        Optional<EducationImage> byId = educationImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的教育经历照片不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<EducationImage> byId = educationImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的教育经历照片");
        }
        EducationImage educationImage = byId.get();
        educationImage.setDeleteTag(1);
        educationImageRepository.save(educationImage);
        return true;
    }

    @Override
    public Specification<EducationImage> specificationBuild(EducationImage educationImage) {
        return null;
    }
}
