package DesignTwitter;

import java.util.*;

/**
 * 题目：355.设计推特
 * 设计一个简化版的推特(Twitter)，可以让用户实现发送推文，关注/取消关注其他用户
 * 能够看见关注人（包括自己）的最近十条推文。你的设计需要支持以下的几个功能：
 * postTweet(userId, tweetId): 创建一条新的推文
 * getNewsFeed(userId): 检索最近的十条推文。每个推文都必须是由此用户关注的人或者是用户自己发出的。推文必须按照时间顺序由最近的开始排序。
 * follow(followerId, followeeId): 关注一个用户
 * unfollow(followerId, followeeId): 取消关注一个用户
 * 示例:
 * Twitter twitter = new Twitter();
 * <p>
 * 用户1发送了一条新推文 (用户id = 1, 推文id = 5).
 * twitter.postTweet(1, 5);
 * <p>
 * 用户1的获取推文应当返回一个列表，其中包含一个id为5的推文.
 * twitter.getNewsFeed(1);
 * <p>
 * 用户1关注了用户2.
 * twitter.follow(1, 2);
 * <p>
 * 用户2发送了一个新推文 (推文id = 6).
 * twitter.postTweet(2, 6);
 * <p>
 * 用户1的获取推文应当返回一个列表，其中包含两个推文，id分别为 -> [6, 5].
 * 推文id6应当在推文id5之前，因为它是在5之后发送的.
 * twitter.getNewsFeed(1);
 * <p>
 * 用户1取消关注了用户2.
 * twitter.unfollow(1, 2);
 * <p>
 * 用户1的获取推文应当返回一个列表，其中包含一个id为5的推文.
 * 因为用户1已经不再关注用户2.
 * twitter.getNewsFeed(1);
 * <p>
 * 说明：你不能倾斜容器，且 n 的值至少为 2。
 * 示例：
 * 输入：[1,8,6,2,5,4,8,3,7]
 * 输出：49
 *
 * @author HuangXiahao
 * @version V1.0
 * @class DesignTwitter
 * @packageName my.test.hello
 * @data 2020/4/13
 **/
public class DesignTwitter {

    public static void main(String[] args) {
        Twitter twitter = new Twitter();
        twitter.follow(1, 2);
        twitter.postTweet(2, 6);
        twitter.postTweet(2, 3);
        twitter.postTweet(1, 5);
        twitter.postTweet(2, 4);
        twitter.getNewsFeed(1);
        System.out.println("1");
    }

    static
    class Twitter {
        Integer currentNum = 0;
        ArrayList hasTweetIds = new ArrayList();
        HashMap<Integer, User> userMap = new HashMap();

        /**
         * Initialize your data structure here.
         */
        public Twitter() {

        }

        /**
         * Compose a new tweet.
         */
        public void postTweet(int userId, int tweetId) {
            if (!hasTweetIds.contains(tweetId)) {
                hasTweetIds.add(tweetId);
                if (userMap.containsKey(userId)) {
                    userMap.get(userId).addTweet(++currentNum, tweetId);
                } else {
                    User user = new User();
                    user.addTweet(++currentNum, tweetId);
                    userMap.put(userId, user);
                }
            }
        }

        /**
         * Retrieve the 10 most recent tweet ids in the user's news feed. Each item in the news feed must be posted by users who the user followed or by the user herself. Tweets must be ordered from most recent to least recent.
         */
        public List<Integer> getNewsFeed(int userId) {
            List<Integer> resultList = new ArrayList();
            if (userMap.containsKey(userId)) {
                TreeMap<Integer, Integer> tweetMap = new TreeMap(new Comparator<Integer>() {
                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o2.compareTo(o1);
                    }
                });
                User user = userMap.get(userId);
                tweetMap.putAll(user.tweetMap);
                for (int i = 0; i < user.looks.size(); i++) {
                    if (userMap.containsKey(user.looks.get(i))) {
                        tweetMap.putAll(userMap.get(user.looks.get(i)).tweetMap);
                    }
                }
                if (tweetMap.size() > 10) {
                    int i = 0;
                    for (Integer value :
                            tweetMap.values()) {
                        if (i == 10) {
                            break;
                        }
                        resultList.add(value);
                        i++;
                    }
                } else {
                    resultList.addAll(tweetMap.values());
                }
            }
            return resultList;
        }

        /**
         * Follower follows a followee. If the operation is invalid, it should be a no-op.
         */
        public void follow(int followerId, int followeeId) {
            if (userMap.containsKey(followerId)) {
                userMap.get(followerId).addLook(followeeId);
            } else {
                User user = new User();
                user.addLook(followeeId);
                userMap.put(followerId, user);
            }
        }

        /**
         * Follower unfollows a followee. If the operation is invalid, it should be a no-op.
         */
        public void unfollow(int followerId, int followeeId) {
            if (userMap.containsKey(followerId)) {
                userMap.get(followerId).delLook(followeeId);
            }
        }

        class User {

            HashMap<Integer, Integer> tweetMap = new HashMap();
            ArrayList<Integer> looks = new ArrayList();

            private void addLook(Integer id) {
                if (!looks.contains(id)) {
                    looks.add(id);
                }
            }

            private void delLook(Integer id) {
                if (looks.contains(id)) {
                    for (int i = 0; i < looks.size(); i++) {
                        if (looks.get(i) == id) {
                            looks.remove(i);
                        }
                    }
                }
            }

            private void addTweet(Integer num, Integer id) {
                tweetMap.put(num, id);
            }
        }
    }

/**
 * Your Twitter object will be instantiated and called as such:
 * Twitter obj = new Twitter();
 * obj.postTweet(userId,tweetId);
 * List<Integer> param_2 = obj.getNewsFeed(userId);
 * obj.follow(followerId,followeeId);
 * obj.unfollow(followerId,followeeId);
 */

}
