package snowflake;

import xyz.downgoon.snowflake.Snowflake;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

/**
 * 描述：雪花算法测试类
 * @author HuangXiahao
 * @version V1.0
 * @class TestSnowFake
 * @packageName my.test.hello.snowfake
 * @data 2020/5/31
 **/
public class TestSnowFlake {

    public static void main(String[] args) {
        //测试个数
        long n = 100_000_000;
        //线程数
        int threadNum = 10;
        //序列号位数
        int sequenceLength = 14;
        //测试5次
        for (int i = 0; i < 5; i++) {
            System.out.println(startWithThread(n, threadNum,sequenceLength));
        }
    }

     /**
      * @param num 测试数量
      * @param threadNum 线程数量
      * @param sequenceLength 序列号位数
      * @Return : snowflake.TestSnowFlake.TimeAndQPS
      * @Author : HuangXiahao
      * @Date : 2020/6/8 11:24
     */
    public static TimeAndQPS startWithThread(long num, int threadNum,long sequenceLength) {
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        SnowFlake snowFake = new SnowFlake(sequenceLength);
        long start = System.currentTimeMillis();
        for (int i = 0; i < threadNum; i++) {
            executorService.submit(new SnowFlakThread(snowFake, num / threadNum));
        }
        //暂停主线程直到num个雪花ID生成完毕
        while (snowFake.getAtomicLong() != num) {
        }
        long end = System.currentTimeMillis();
        executorService.shutdown();
        return new TimeAndQPS((num / (end - start) * 1.0) * 1000.0,end-start);
    }

    /*
     * 用于存放测试数据
     * */
    static class  TimeAndQPS{
        private double QPS;
        private long time;

        public TimeAndQPS(double QPS, long time) {
            this.QPS = QPS;
            this.time = time;
        }

        @Override
        public String toString() {
            return "每秒QPS："+this.QPS+"    所用时间：" + this.time;
        }
    }

}
