package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.service.FlowInfoService;
import com.tykj.workflowcore.workflow_editer.service.WorkFlowService;
import com.tykj.workflowcore.workflow_editer.util.PageUtil;
import com.tykj.workflowcore.workflow_editer.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.flowable.task.api.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;

/**
 * ClassName:    WorkFlowController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/2   9:48
 *
 * @Author: zsp
 */
@Api("工作流管理接口")
@RestController
@RequestMapping("/workFlow")
public class WorkFlowController {

    @Autowired
    private FlowInfoService flowInfoService;

    @Autowired
    private WorkFlowService workFlowService;
    @PostMapping("/deploy")
    @ApiOperation(value = "部署流程",notes = "0 部署成功")
    public Integer deploy(Long id) throws FileNotFoundException {
        //根据id 查询出flowsInfo
        FlowsInfo flowsInfo = flowInfoService.findById(id);
        if (flowsInfo.getState() == 0){
            return 0;
        }
        workFlowService.deployXml(flowsInfo);
        return flowsInfo.getState();
    }

    @PostMapping("/startFlow")
    @ApiOperation("开启流程")
    public String startFlow(@RequestBody StartFlowVo startFlowVo){
        workFlowService.startFlow(startFlowVo);
        return null;
    }

    @PostMapping("/findUserTask")
    @ApiOperation("任务个人待办列表")
    public List<Map<String,Object>> findUserTask(@RequestBody NextTaskVo nextTaskVo){

        return workFlowService.findTaskByUserId(nextTaskVo);

    }

    @PostMapping("/findTaskDetail")
    @ApiOperation("任务个人待办详情")
    public Map<String, Object> findTaskDetail(Long userId,String taskId){

        return  workFlowService.findTaskDetail(userId, taskId);
    }

    @PostMapping("/completeTask")
    @ApiOperation("完成任务")
    public void completeTask(@RequestBody TaskVo taskVo){
        workFlowService.completeTask(taskVo);
    }

    @PostMapping("/isSuspension")
    @ApiOperation("是否挂起")
    public void isSuspension(@RequestBody SuspendVo suspendVo){
        workFlowService.suspendOrActivateProcessDefinitionByKey(suspendVo);
    }

    @DeleteMapping("/deleteFlow/{deployId}")
    @ApiOperation("是否删除")
    public void deleteFlow(@PathVariable("deployId") String deployId){
        //根据流程id查询出flowsInfo
        FlowsInfo flowsInfo = flowInfoService.findByDeployId(deployId);
        //删除flowsInfo
        flowInfoService.deleteById(flowsInfo.getId());
        workFlowService.deleteFlow(deployId);
    }
}
