package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultObj;
import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
//import com.tykj.workflowcore.workflow_editer.entity.PageEntity;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
//import com.tykj.workflowcore.workflow_editer.service.PageEntityService;
import com.tykj.workflowcore.workflow_editer.vo.InFormPageVo;
import com.tykj.workflowcore.workflow_editer.vo.OutFormPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * ClassName:    FormPageController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/3   13:40
 *
 * @Author: zsp
 */
@RestController("/formPage")
@RequestMapping
@Api("页面管理接口")
public class FormPageController {

    @Autowired
    private FormPageService formPageService;

//    @Autowired
//    private PageEntityService pageEntityService;

    @ApiOperation("保存页面")
    @PostMapping("/savePage")
    public ResponseEntity savePage(@RequestBody InFormPageVo inFormPageVo){
        if (inFormPageVo.getId() == null){
            Long pageId = formPageService.savePage(inFormPageVo);
            return ResultUtil.success(pageId,"页面保存成功");
        }else {
            //修改
            FormPage formPage = inFormPageVo.toEntity();
            formPageService.update(formPage);
            return ResultUtil.success(inFormPageVo.getId(),"页面保存成功");
        }
    }
    @ApiOperation("回显页面")
    @GetMapping("/EchoPage")
    public FormPage EchoPage(Long id){
        return  formPageService.getPage(id);
    }

    @ApiOperation("查看页面")
    @GetMapping("/findPages")
    public List<OutFormPageVo> findPages(){
        return  formPageService.getAllPages();
    }

    @ApiOperation("删除页面")
    @DeleteMapping("deletePage")
    public void deletePage(Long id){
        formPageService.deletePage(id);
    }

    @PostMapping("/findByPages")
    public List<TableInfo> findByPages(@RequestBody List<Long> pageIds){
        return formPageService.findByPageIds(pageIds);
    }

}
