package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRole;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRoleType;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowUser;
import com.tykj.workflowcore.workflow_editer.service.UserService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class UserController
 * @packageName com.tykj.workflowcore.workflow_editer.controller
 **/
@RestController()
@RequestMapping("/workflow/user")
@Api("页面管理接口")
public class UserController {

    @Autowired(required = false)
    UserService userService;

    @PostMapping("/getCurrentUser")
    public ResponseEntity getCurrentUser(){
        WorkFlowUser currentUser = userService.getCurrentUser();
        return ResultUtil.success(currentUser,"查询成功");
    }

    @PostMapping("/getAllUser")
    public ResponseEntity getAllUser(){
        List<WorkFlowUser> allUser = userService.getAllUser();
        return ResultUtil.success(allUser,"查询成功");
    }

    @PostMapping("/getAllRole")
    public ResponseEntity getAllRole(String roleType){
        List<WorkFlowRole> allRole = userService.getAllRole(roleType);
        return ResultUtil.success(allRole,"查询成功");

    }

    @PostMapping("/getRoleType")
    public ResponseEntity getRoleType(){
        List<WorkFlowRoleType> roleType = userService.getRoleType();
        return ResultUtil.success(roleType,"查询成功");
    }


}
