package com.tykj.workflowcore.workflow_editer.entity.vo;

import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.vo.OutFormPageVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class VariableStorageVo
 * @packageName com.tykj.workflowcore.workflow_editer.entity.vo
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class VariableStorageVo {

    private Long id;

    private String flowKey;

    private String className;

    private String method;

    private String variableInfo;

    public VariableStorage toEntity(){
        VariableStorage variableStorage = new VariableStorage();
        BeanUtils.copyProperties(this,variableStorage);
        return variableStorage;
    }
}
