package com.tykj.workflowcore.workflow_editer.service;

import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRole;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRoleType;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowUser;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * ClassName:    UserService
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/2/25   13:53
 *
 * @Author: zsp
 */

public interface UserService {

    /**
     * 获取当前登录人的id
     * @return User对象
     */
    WorkFlowUser getCurrentUser();

    /**
     * 获取所有用户
     * @return 所有用户
     */
    List<WorkFlowUser> getAllUser();

    /**
     * 获取当前系统中的用户以及用户分组
     * @return
     */
    List<WorkFlowRole> getAllRole(String roleType);

    /**
     * 获取当前系统中的用户分组类别
     * @return
     */
    List<WorkFlowRoleType> getRoleType();

}
