package com.tykj.workflowcore.workflow_editer.util;

import org.springframework.http.ResponseEntity;

/**
 * 全局错误处理类，用于处理一些不容易定义的错误
 *
 * @author HuangXiahao
 **/
public class ApiException extends RuntimeException {

    private ResponseEntity responseEntity;

    public ApiException(ResponseEntity responseEntity) {
        this.responseEntity = responseEntity;
    }

    public ApiException(String message) {
        this.responseEntity = ResponseEntity.status(400).body(new ResultObj(message));
    }

    public ApiException(String message, Object data) {
        this.responseEntity = ResponseEntity.status(400).body(new ResultObj(data, message));
    }


    public ResponseEntity getResponseEntity() {
        return responseEntity;
    }

    public void setResponseEntity(ResponseEntity responseEntity) {
        this.responseEntity = responseEntity;
    }
}
