package com.tykj.workflowcore.model_layer.model;


import com.tykj.workflowcore.model_layer.annotatiion.WorkFlowCoreNoScan;
import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.UpdateTimestamp;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * @ClassName TableInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:05
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "table_info")
@Data
public class TableInfo implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private long Id;

    @Column(nullable = false,name = "name")
    private String Name;

    @Column(nullable = false,name = "cn_name")
    private String CnName;


    @Column(name = "description")
    private String Desc;

    @Column(name = "type")
    private String Type;

    @Column(name = "reviser")
    private String Reviser;
    @Lob
    @Column(name = "xml",columnDefinition="TEXT")
    private String XML;

    @LastModifiedDate
    @Column(nullable = false,name = "update_time")
    private Date updateTime;

    @CreatedDate
    @Column(nullable = false, updatable = false,name = "create_time")
    private Date createTime;


}
