package com.tykj.workflowcore.workflow_editer.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * ClassName:    Swagger2Config
 * Package:    com.tykj.config
 * Description: swagger配置
 * @Author: zsp
 */
@Configuration
@EnableSwagger2
public class Swagger2Config {
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
               .apiInfo(apiInfo()).select()
                .apis(RequestHandlerSelectors.basePackage("com.tykj"))
                .paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("工作流开发")
                .description("工作流开发接口文档与测试页面")
                .version("v1.0")
                .build();
    }
}
