package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.model_layer.annotatiion.WorkFlowCoreNoScan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

/**
 * ClassName:    SiteMessage
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/2/23   10:29
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@WorkFlowCoreNoScan
@Api("消息发送")
public class SiteMessage {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("消息id")
    private Long id;

    @ApiModelProperty("用户id")
    private Integer userId;

    @ApiModelProperty(value = "消息类型",notes = "1  待办任务")
    private Integer type;

    @ApiModelProperty("消息内容")
    private String content;

    @ApiModelProperty(value = "是否已读",notes = "0 已读  1  未读")
    private Integer isRead;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;
}
