package com.tykj.workflowcore.workflow_editer.entity;

import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class Test
 * @packageName com.example.flowable.expense.controller
 **/
public class CommandGetValue implements Command<Object> {

    private String processInstanceId;

    private Expression expression;

    public CommandGetValue(String processInstanceId, Expression expression) {
        this.processInstanceId = processInstanceId;
        this.expression = expression;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();

        ExecutionEntity executionEntity = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId).get(0);
        return expression.getValue(executionEntity);
    }
}
