package com.tykj.workflowcore.workflow_editer.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.vo.SearchFlowInfoVo;
import com.tykj.workflowcore.workflow_editer.mapper.FlowsInfoMapper;
import com.tykj.workflowcore.workflow_editer.service.FlowInfoService;
import com.tykj.workflowcore.workflow_editer.vo.FlowsInfoVo;
import com.tykj.workflowcore.workflow_editer.vo.PageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Optional;

/**
 * ClassName:    FlowInfoServiceImpl
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/2/24   10:15
 *
 * @Author: zsp
 */
@Service
public class FlowInfoServiceImpl implements FlowInfoService {

    @Autowired
    private FlowsInfoMapper flowsInfoMapper;

    @Override
    public FlowsInfo findById(Long id) {
        return flowsInfoMapper.findById(id).get();
    }

    @Override
    public FlowsInfo findByFlowName(@RequestBody FlowsInfoVo flowsInfoVo) {
        String flowKey = flowsInfoVo.getFlowKey();
        String flowName = flowsInfoVo.getFlowName();
        FlowsInfo flowsInfo = flowsInfoMapper.findByFlowKey(flowKey);
        flowsInfo.setFlowName(flowName);
        //进行更新
        FlowsInfo newFlowsInfo = flowsInfoMapper.save(flowsInfo);
        return newFlowsInfo;
    }

    @Override
    public FlowsInfo findByDesc(@RequestBody FlowsInfoVo flowsInfoVo) {

        String flowKey = flowsInfoVo.getFlowKey();
        String describe = flowsInfoVo.getFlowDescribe();
        FlowsInfo byDesc = flowsInfoMapper.findByFlowKey(flowKey);
        byDesc.setFlowDescribe(describe);
//        //进行更新
//        FlowsInfo flowsInfo = flowsInfoMapper.save(byDesc);
        return flowsInfoMapper.save(byDesc);
    }

    @Override
    public FlowsInfo findByDeployId(String deployId) {
        return flowsInfoMapper.findByDeployId(deployId);
    }

    @Override
    public void deleteById(Long id) {
        flowsInfoMapper.deleteById(id);
    }

    @Override
    public FlowsInfo findByFlowKey(String flowKey) {
        return flowsInfoMapper.findByFlowKey(flowKey);
    }

    @Override
    public FlowsInfo disableFlow(Long flowInfoId) {
        Optional<FlowsInfo> byId = flowsInfoMapper.findById(flowInfoId);
        if (byId.isPresent()){
            FlowsInfo flowsInfo = byId.get();
            flowsInfo.setState(1);
            flowsInfoMapper.save(flowsInfo);
        }else {
            throw new ApiException("要禁用的流程不存在");
        }
        return null;
    }

    @Override
    public Page<FlowsInfo> searchFlowInfo(SearchFlowInfoVo searchFlowInfoVo) {
        PredicateBuilder<FlowsInfo> and = Specifications.and();
        and.eq(searchFlowInfoVo.getState()!=null,"state",searchFlowInfoVo.getState());
        and.eq(searchFlowInfoVo.getFlowKey()!=null,"flowKey",searchFlowInfoVo.getFlowKey());
        and.like(searchFlowInfoVo.getFlowName()!=null,"flowName","%"+searchFlowInfoVo.getFlowName()+"%");
        return flowsInfoMapper.findAll(and.build(), searchFlowInfoVo.getPageable());
    }
}
