package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.NodePage;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowUser;
import com.tykj.workflowcore.workflow_editer.entity.vo.VariableStorageVo;
import com.tykj.workflowcore.workflow_editer.service.*;
import com.tykj.workflowcore.workflow_editer.vo.DeployedVo;
import com.tykj.workflowcore.workflow_editer.vo.FlowsInfoVo;
import com.tykj.workflowcore.workflow_editer.vo.PageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;


/**
 * ClassName:    FlowsInfoController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/2/24   10:13
 * @Author: zsp
 */
@RestController
@Api("流程管理接口")
@RequestMapping("/flowsInfo")
public class FlowsInfoController {

    @Autowired
    private FlowInfoService flowInfoService;

    @Autowired
    private WorkFlowService workFlowService;

    @Autowired
    private NodePageService nodePageService;

    @Autowired
    private UserService userService;

    @Autowired
    private VariableStorageService variableStorageService;

    @PostMapping("/getAllFlowsInfo")
    @ApiOperation(value = "查询所有流程",notes = "分页查询")
    public Page<FlowsInfo> getAllFlowsInfo(@RequestBody PageVo pageVo){
        if (pageVo.getPageNum() == 0){
            pageVo.setPageNum(1);
        }
        return flowInfoService.getAllFlowsInfo(pageVo);
    }
    @PostMapping("/getDeployedFlowsInfo")
    @ApiOperation(value = "查询已经部署的流程")
    public List<DeployedVo> getDeployedFlowsInfo(){

        ArrayList<DeployedVo> deployedVos = new ArrayList<>();
        //查询已经部署的流程
        List<FlowsInfo> deployedFlowsInfo = flowInfoService.getDeployedFlowsInfo();
        for (FlowsInfo flowsInfo : deployedFlowsInfo) {

            String flowKey = flowsInfo.getFlowKey();
            String flowName = flowsInfo.getFlowName();
            String startId = flowsInfo.getStartId();
            DeployedVo deployedVo = new DeployedVo();
            BeanUtils.copyProperties(flowsInfo,deployedVo);
            //通过节点id得到pageId
            Long pageId = nodePageService.findByNodeId(startId);
            deployedVo.setPageId(pageId);
            deployedVos.add(deployedVo);
        }
        return deployedVos;
    }

    @GetMapping("/deploy")
    @ApiOperation(value = "部署流程",notes = "0 部署成功")
    public ResponseEntity deploy(Long id) throws FileNotFoundException {
        //根据id 查询出flowsInfo
        FlowsInfo flowsInfo = flowInfoService.findById(id);
        if (flowsInfo.getState() == 0){
            return ResultUtil.success(flowsInfo.getState(),"该流程已经被部署");
        }
        workFlowService.deployXml(flowsInfo);
        return ResultUtil.success(flowsInfo.getState(),"流程部署成功");
    }

    @PostMapping("/saveXml02")
    @ApiOperation(value = "保存xml02")
    public ResponseEntity saveXml02(@RequestBody FlowsInfoVo flowsInfoVo) {
        List<NodePage> nodePages = flowsInfoVo.getNodePages();
        nodePageService.saveNodePages(nodePages);
        workFlowService.flowXml(flowsInfoVo);
        return ResultUtil.success("文件保存成功");
    }

    @PostMapping("/updateByProcessName")
    @ApiOperation(value = "通过流程名称修改")
    public ResponseEntity updateByProcessName(@RequestBody FlowsInfoVo flowsInfoVo) {
        FlowsInfo flowsInfo = flowInfoService.findByFlowName(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowName(),"流程修改成功");
    }

    @PostMapping("/updateByDesc")
    @ApiOperation(value = "通过流程描述修改")
    public ResponseEntity updateByDesc(@RequestBody FlowsInfoVo flowsInfoVo) {

        FlowsInfo flowsInfo = flowInfoService.findByDesc(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowDescribe(),"流程修改成功");
    }

    @PostMapping("/createFlow")
    @ApiModelProperty("创建成功")
    public ResponseEntity createFlow(@RequestBody FlowsInfoVo flowsInfovo){
        return ResultUtil.success(workFlowService.createFlow(flowsInfovo.toEntity()),"流程创建成功");
    }

    @PostMapping("/saveVariableStorage")
    @ApiModelProperty("保存函数调用配置")
    public ResponseEntity saveVariableStorage(@RequestBody VariableStorageVo variableStorageVo){
        VariableStorage variableStorage = variableStorageService.saveVariableStorageService(variableStorageVo.toEntity());
        return ResultUtil.success(variableStorage,"调用接口成功");
    }
    
    @PostMapping("/test")
    public WorkFlowUser test(){
        return userService.getCurrentUser();
    }

}
