# 工作流项目核心
## 项目简介

### 环境要求
- Maven3+
- Jdk1.8+
- springboot 2.4.1 以下 2.1.4 以上 （包含所提到的版本）

### 代码结构
```
├─src
│  ├─main
│  │  ├─java
│  │  │  └─com
│  │  │      └─tykj
│  │  │          └─workflowcore
│  │  │              ├─api  
│  │  │              ├─base --系统基础模块
│  │  │              │  ├─annotations --注解类
│  │  │              │  ├─aop 
│  │  │              │  ├─config
│  │  │              │  ├─entity
│  │  │              │  ├─page
│  │  │              │  ├─result
│  │  │              │  └─util
│  │  │              ├─model_layer --数据模型
│  │  │              │  ├─annotations 
│  │  │              │  ├─controller 
│  │  │              │  ├─dao 
│  │  │              │  ├─entity
│  │  │              │  │  └─vo
│  │  │              │  ├─service
│  │  │              │  │  └─impl
│  │  │              │  ├─util
│  │  │              ├─workflow_editor   --工作流编辑器
│  │  │              │  ├─config
│  │  │              │  ├─controller 
│  │  │              │  ├─dao 
│  │  │              │  ├─entity
│  │  │              │  │  └─vo
│  │  │              │  ├─enums
│  │  │              │  ├─listener
│  │  │              │  ├─service
│  │  │              │  │  └─impl
│  │  │              │  ├─util
│  │  │              └─WorkflowCoreApplication  --SpringBoot启动类
│  │  └─resources   --核心配置所在位置
│  │      ├─mapper
│  │      ├─template
│  │      └─ui
│  │          └─images
│  └─test
│      └─java
│          └─org
│              └─yaukie
│                  └─frame   --核心逻辑所在位置
```
## 使用方式
### 安装
#### maven
```
        <dependency>
            <groupId>com.tykj</groupId>
            <artifactId>workflow-core</artifactId>
            <version>0.0.1-SNAPSHOT</version>
        </dependency>
```
#### 本地引入
 1. 获取 workflow-core-0.0.1-SNAPSHOT.jar
 2. 在你自己项目的根目录下创建lib文件夹  并将 jar 包放入
 3. pom 添加 如下
 
```
        <dependency>
            <groupId>com.tykj</groupId>
            <artifactId>workflow-core</artifactId>
            <version>0.0.1-SNAPSHOT</version>
            <scope>system</scope>
            <systemPath>${basedir}/lib/workflow-core-0.0.1-SNAPSHOT.jar</systemPath>
        </dependency>
```
### 调用
1. 在springboot 启动类上添加注解 @EnableWorkFlowCore 
```
@EnableWorkFlowCore
@SpringBootApplication
public class DemoApplication {

    public static void main(String[] args) {
        SpringApplication.run(WorkflowCoreApplication.class, args);
    }

}
```
2. 如需要使用工作流的审批人功能请实现 UserService 
例如：
```
@Service
@Primary
public class FlowUserServiceImpl implements UserService {

    @Override
    public WorkFlowUser getCurrentUser() {
        WorkFlowUser workFlowUser = new WorkFlowUser();
        workFlowUser.setId(1L);
        workFlowUser.setUserName("张三");
        return workFlowUser;
    }

    @Override
    public List<WorkFlowUser> getAllUser() {
        List<WorkFlowUser> workFlowUsers = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            WorkFlowUser workFlowUser = new WorkFlowUser();
            workFlowUser.setUserName("张1");
            workFlowUser.setId((long) i);
            workFlowUsers.add(workFlowUser);
        }
        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRole> getAllRole(String roleType) {
        List<WorkFlowRole> workFlowUsers = new ArrayList<>();
        if (roleType.equals("department")){
            workFlowUsers.add(new WorkFlowRole("开发部","department","1"));
            workFlowUsers.add(new WorkFlowRole("运营部","department","2"));
            workFlowUsers.add(new WorkFlowRole("测试部","department","3"));
        }else {
            workFlowUsers.add(new WorkFlowRole("管理员","role","1"));
            workFlowUsers.add(new WorkFlowRole("普通用户","role","2"));
            workFlowUsers.add(new WorkFlowRole("运维人员","role","3"));
        }

        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRoleType> getRoleType() {
        List<WorkFlowRoleType> workFlowRoleTypes = new ArrayList<>();
        workFlowRoleTypes.add(new WorkFlowRoleType("部门","department"));
        workFlowRoleTypes.add(new WorkFlowRoleType("角色","role"));
        return workFlowRoleTypes;
    }

}
```


