package com.tykj.workflowcore.model_layer.service;


import com.tykj.workflowcore.model_layer.entity.ColumnInfo;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.entity.vo.QueryCondition;
import com.tykj.workflowcore.model_layer.entity.vo.SearchColumnInfoVo;
import com.tykj.workflowcore.model_layer.entity.vo.SearchTableInfoVo;
import com.tykj.workflowcore.model_layer.entity.vo.TableVO;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;


import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelService
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:36
 * @Version 1.0
 */
@Service
public interface ModelService {

    /**
     * 分页查询
     * @param searchTableInfoVo
     * @return
     * @throws SQLException
     */
    Page<TableInfo> listAllEntities(SearchTableInfoVo searchTableInfoVo) throws SQLException;

    /**
     * 方法重载不分页查询
     * @return
     * @throws SQLException
     */
    List<TableInfo> listAllEntities() throws SQLException;


    /**
     * 根据表名查询所有字段信息
     * @param searchColumnInfoVo
     * @return
     */
    List<ColumnInfo> showModelFields(SearchColumnInfoVo searchColumnInfoVo);


    /**
     * 新建模型
     * @param tableVO
     * @return
     */
    TableVO newTable(TableVO tableVO);

    /**
     * 根据表名插入数据
     * @param map
     * @return
     */
    int putValueByEntityName(Map<String, Object> map);

    /**
     * 扫描
     * @param classList
     */
    void swaggerScan(List<Class<?>> classList);

    /**
     * 根据表名查询所有
     * @param name
     * @return
     * @throws SQLException
     */
    List findAllByName(String name) throws SQLException;


    /**
     * 复杂查询
     * @param tableName
     * @param queryConditions
     * @return
     */
    List complexQuery(String tableName, List<QueryCondition> queryConditions);
}
