package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRole;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRoleType;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowUser;
import com.tykj.workflowcore.workflow_editer.service.UserService;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DefaultUserSerbiveImpl
 * @packageName com.tykj.workflowcore.workflow_editer.service.impl
 **/
@Service
@Order
public class DefaultUserServiceImpl implements UserService {

    @Override
    public WorkFlowUser getCurrentUser() {
        WorkFlowUser workFlowUser = new WorkFlowUser();
        workFlowUser.setId(1);
        workFlowUser.setUserName("张三");
        return workFlowUser;
    }

    @Override
    public List<WorkFlowUser> getAllUser() {
        List<WorkFlowUser> workFlowUsers = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            WorkFlowUser workFlowUser = new WorkFlowUser();
            workFlowUser.setUserName("张1");
            workFlowUser.setId(i);
            workFlowUsers.add(workFlowUser);
        }
        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRole> getAllRole(String roleType) {
        List<WorkFlowRole> workFlowUsers = new ArrayList<>();
        if (roleType.equals("department")){
            workFlowUsers.add(new WorkFlowRole("开发部","department","1"));
            workFlowUsers.add(new WorkFlowRole("运营部","department","2"));
            workFlowUsers.add(new WorkFlowRole("测试部","department","3"));
        }else {
            workFlowUsers.add(new WorkFlowRole("管理员","role","1"));
            workFlowUsers.add(new WorkFlowRole("普通用户","role","2"));
            workFlowUsers.add(new WorkFlowRole("运维人员","role","3"));
        }

        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRoleType> getRoleType() {
        List<WorkFlowRoleType> workFlowRoleTypes = new ArrayList<>();
        workFlowRoleTypes.add(new WorkFlowRoleType("部门","department"));
        workFlowRoleTypes.add(new WorkFlowRoleType("角色","role"));
        return workFlowRoleTypes;
    }
}
