package com.tykj.workflowcore.workflow_editer.service.impl;

import cn.hutool.extra.spring.SpringUtil;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.NodePage;
import com.tykj.workflowcore.workflow_editer.entity.Role;
import com.tykj.workflowcore.workflow_editer.entity.User;
import com.tykj.workflowcore.workflow_editer.mapper.FlowsInfoMapper;
import com.tykj.workflowcore.workflow_editer.mapper.RoleMapper;
import com.tykj.workflowcore.workflow_editer.mapper.UserMapper;
import com.tykj.workflowcore.workflow_editer.service.NodePageService;
import com.tykj.workflowcore.workflow_editer.service.WorkFlowService;
import com.tykj.workflowcore.workflow_editer.vo.*;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.util.*;

/**
 * ClassName:    FlowableServiceImpl
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/2/23   13:46
 *
 * @Author: zsp
 */
@Service
public class WorkFlowServiceImpl implements WorkFlowService {

    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private FlowsInfoMapper flowsInfoMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;

    @Autowired
    private NodePageService nodePageService;

    @Autowired
    ClassLoader classLoader;
    @Override
    public String saveXml(@RequestParam("file") MultipartFile file) {

        String realPath = null;
        if (!file.isEmpty()) {
            //获取文件名
            String fileName = file.getOriginalFilename();
            System.out.println(fileName);
            //获取文件后缀
            String suffixName = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            System.out.println(fileName);
            //指定本地存入路径
            File fileNew = new File(classLoader.getResource("").getPath() + fileName);
            realPath = classLoader.getResource("").getPath()+fileName;
            try {
                file.transferTo(fileNew);
            } catch (IOException e) {
                e.printStackTrace();
            }

            //解析xml
            //1.创建Reader对象
            SAXReader reader = new SAXReader();
            //2.加载xml
            Document document = null;
            try {
                document = reader.read(fileNew);
            } catch (DocumentException e) {
                e.printStackTrace();
            }
            //3.获取根节点
            Element rootElement = document.getRootElement();
            Iterator iterator = rootElement.elementIterator();
            String processId = null;
            String processName = null;
            Element stu = (Element) iterator.next();
            List<Attribute> attributes = stu.attributes();
            System.out.println("======获取属性值======");
            for (Attribute attribute : attributes) {
                if ("id".equals(attribute.getName())){
                    processId = attribute.getValue();
                    System.out.println("processId的值是:"+processId);
                }
                if ("name".equals(attribute.getName())){
                    processName = attribute.getValue();
                    System.out.println("processName的值是:"+processName);
                }
            }
            //保存processId和processName 到数据库里面
            FlowsInfo flowsInfo = new FlowsInfo();
            flowsInfo.setFlowKey(processId);
            flowsInfo.setFlowName(processName);
            flowsInfo.setResourceName(file.getOriginalFilename());
            flowsInfo.setCreateTime(new Date());
            //状态为未部署
            flowsInfo.setState(1);
            flowsInfo.setFilePath(realPath);
            flowsInfoMapper.save(flowsInfo);
        }
        return realPath;
    }

    @Override
    public void flowXml(@RequestBody FlowsInfoVo flowsInfoVo) {

        Long id = flowsInfoVo.getId();
        String flowKey = flowsInfoVo.getFlowKey();
        String fileXml = flowsInfoVo.getFileXml();

        //生成xml文件
        File f = null;
        try {
             f = new File(classLoader.getResource("").getPath()+"/xml/"+flowKey+"bpmn20.xml");
            // 判断文件是否存在
            if(!f.exists()){
                f.createNewFile();
            }
            System.out.println("生成"+flowKey+".xml成功");
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("生成"+flowKey+".xml失败");
        }

        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new StringReader(fileXml));
            bufferedWriter = new BufferedWriter(new FileWriter(f));
            //字符缓冲区
            char buf[] = new char[1024];
            int len;
            while ((len = bufferedReader.read(buf)) != -1) {
                bufferedWriter.write(buf, 0, len);
            }
            bufferedWriter.flush();
            bufferedReader.close();
            bufferedWriter.close();
        } catch (IOException e) {
            e.printStackTrace();

        } finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        FlowsInfo flowsInfo = new FlowsInfo();
        BeanUtils.copyProperties(flowsInfoVo,flowsInfo);
        flowsInfo.setResourceName(flowKey+"bpmn20.xml");
        flowsInfo.setCreateTime(new Date());
        //状态为未部署
        flowsInfo.setState(1);
        flowsInfo.setFilePath(classLoader.getResource("").getPath()+"/xml/"+flowKey+"bpmn20.xml");
        flowsInfo.setId(id);
        //更新并保存
        flowsInfoMapper.save(flowsInfo);
    }

    @Override
    public Long createFlow(FlowsInfo flowsInfo ) {

        FlowsInfo flowsInfo1 = flowsInfoMapper.save(flowsInfo);
        return flowsInfo1.getId();
    }


    @Override
    public void deployXml(FlowsInfo flowsInfo) throws FileNotFoundException {

        Deployment deploy = null;
        try {
            deploy = repositoryService.createDeployment().addInputStream(flowsInfo.getResourceName(),
                    new FileInputStream(flowsInfo.getFilePath())).deploy();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        //修改状态
        flowsInfo.setState(0);
        flowsInfo.setDeployId(deploy.getId());
        flowsInfoMapper.save(flowsInfo);

    }

    @Override
    public void startFlow(@RequestBody StartFlowVo startFlowVo) {

        //获取流程主键
        String flowKey = startFlowVo.getFlowKey();
        //获取变量池
        Map<String, Object> map = startFlowVo.getMap();
        ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(flowKey, map);


        Task task =
                taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId()).singleResult();
        //获取当前人登录的id
//        UserDetails userDetails = userService.getCurrentUserId();
//        String username = userDetails.getUsername();
        //通过用户名得到用户id
        Long userId = 123L;
        taskService.setAssignee(task.getId(),Long.toString(userId));
        //调用业务服务接口  插入数据到记录表中 例如请假是插入请假表
        taskService.complete(task.getId());

    }


    @Override
    public List<Task> findTaskByUserId(NextTaskVo nextTaskVo) {

        TaskQuery taskQuery = taskService.createTaskQuery().or();
        if (nextTaskVo.getUserId()!=null){
            taskQuery.taskCandidateUser(nextTaskVo.getUserId()).orderByTaskCreateTime().desc();
        }
        if (nextTaskVo.getRoleId()!=null&&nextTaskVo.getRoleId().size()>0){
            taskQuery.taskCandidateGroupIn(nextTaskVo.getRoleId()).orderByTaskCreateTime().desc();
        }
        List<Task> listTask = taskQuery.endOr().list();

        return listTask;

    }

    @Override
    public Map<String, Object> findTaskDetail(Long userId, String taskId) {

        Map<String, Object> variables = taskService.getVariables(taskId);
        return variables;
    }

    @Override
    public List<Map<String, Object>> findByRoleId(Long roleId) {
       //流程变量  ${roleId == 具体的数值}
        // 先获取当前登录人的id

        //通过userId来获取roleId

        //根据roleId来查询userName
        Role role = roleMapper.findById(roleId).get();
        List<User> userList = role.getUserList();
        List<Task> taskList = taskService.createTaskQuery().taskCandidateUser(Long.toString(roleId)).list();
        ArrayList<Map<String, Object>> list = new ArrayList<>();
        for (User user : userList) {
            for (Task task : taskList) {
                Map<String, Object> map = new HashMap<>();
                map.put("taskId",task.getId());
                map.put("taskName",task.getName());
                map.put("taskAssigne",user.getUserName());
                map.put("time",task.getCreateTime());
                map.put("description",task.getDescription());
                map.put("processInstanceId",task.getProcessInstanceId());
                list.add(map);
            }
        }
        return list;
    }

    @Override
    public void completeTask(@RequestBody TaskVo taskVo) {

        Map<String, Object> map = new HashMap<>();
        setVariables(taskVo.getMap());

        Task task = taskService.createTaskQuery().taskId(taskVo.getTaskId()).singleResult();
        String processInstanceId = task.getProcessInstanceId();

        taskService.addComment(task.getId(),processInstanceId,taskVo.getComments());
        //先判断是不是表达式
        if (taskVo.getConditionalExpression()!= null){
            taskService.complete(task.getId());
        }else {
            map.put("handlingOpinion",taskVo.getHandlingOpinion());
            taskService.complete(task.getId(),map);
        }

    }

    @Override
    public void claimTask(String taskId, Long userId) {
        //当前登录人的Id
        taskService.claim(taskId,Long.toString(userId));
    }

    @Override
    public void transferTask(String taskId,Long userId) {
       taskService.setAssignee(taskId,Long.toString(userId));
    }

    @Override
    public void suspendOrActivateProcessDefinitionByKey(SuspendVo suspendVo) {
        if (suspendVo.getSuspensionState() == 1){
            repositoryService.suspendProcessDefinitionByKey(suspendVo.getProcessDefinitionKey(), true, new Date());
        }else {
            repositoryService.activateProcessDefinitionById(suspendVo.getProcessDefinitionKey(),true, new Date());
        }
    }

    @Override
    public void deleteFlow(String deployId) {
        repositoryService.deleteDeployment(deployId);
    }

    @Override
    public  Map<String,Object> setVariables(@RequestBody  Map<String,Object> maxMap) {

        Map<String, Object> map = new HashMap<>();
        map.putAll(maxMap);
        return map;
    }

}
