package com.tykj.workflowcore.base.aop;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

import java.util.Arrays;

/**
 * ClassName:    EntityAop
 * Package:    com.tykj.workflowcore.base.aop
 * Description:
 * Datetime:    2021/3/11   19:40
 *
 * @Author: zsp
 */
@Aspect
public class EntityAop {
    @Before("execution(* save*(..))")
    public void permissionCheck(JoinPoint point) {
        System.out.println("@Before：模拟权限检查...");
        System.out.println("@Before：目标方法为：" +
                point.getSignature().getDeclaringTypeName() +
                "." + point.getSignature().getName());
        System.out.println("@Before：参数为：" + Arrays.toString(point.getArgs()));
        System.out.println("@Before：被织入的目标对象为：" + point.getTarget());
    }
}
