package com.tykj.workflowcore.model_layer.model;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotatiion.WorkFlowCoreNoScan;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.*;

/**
 * @ClassName ColumnInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:14
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Entity
@Data
@SQLDelete(sql = "update column_info set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
public class ColumnInfo extends BaseEntity {

    /**
     * 是否primary key， 0是，1否
     */
    @ApiModelProperty("是否主键")
    @Column(name = "primary_key")
    private Integer primaryKey;

    @ApiModelProperty("列名")
    private String name;
    @ApiModelProperty("列名中文描述")
    private String cnName;
    @ApiModelProperty("列类型")
    private String type;
    @ApiModelProperty("长度")
    private Integer length;
    @ApiModelProperty("所属表名")
    private String dbName;
    @ApiModelProperty("所属表id")
    private Integer dbId;



}
