package com.tykj.workflowcore.model_layer.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import com.tykj.workflowcore.model_layer.dao.ColumnInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.model.ColumnInfo;
import com.tykj.workflowcore.model_layer.model.ColumnVO;
import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.model_layer.model.TableVO;
import com.tykj.workflowcore.model_layer.service.ModelService;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;


import javax.persistence.Query;
import javax.persistence.criteria.*;
import javax.xml.crypto.Data;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @ClassName MoedelImpl
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:39
 * @Version 1.0
 */
@Transactional
@Service
public class ModelImpl implements ModelService {

    @Autowired
    private Map<String, Object> cacheMap;

    @Autowired
    private EntityManagerFactory entityManagerFactory;

    @Autowired
    private TableInfoDao tableInfoDao;

    @Autowired
    private ColumnInfoDao columnInfoDao;



    @Override
    public List<TableInfo> ListAllEntities() {
        List<TableInfo> all = tableInfoDao.findAll();
        return all;
    }


    @Override
    public List<ColumnInfo> showModelFields(String TableName) {

        Specification specification = (Specification) (root, criteriaQuery, criteriaBuilder) -> {
            Path db_name = root.get("DbName");
            Predicate equal = criteriaBuilder.equal(db_name, TableName);
            return equal;

        };
        List<ColumnInfo> all = columnInfoDao.findAll(specification);
        return all;
    }

    @Override
    public TableVO addModel(String jsonStr) {
        ObjectMapper mapper = new ObjectMapper();
        TableVO tableVO = null;
        try {
            tableVO = mapper.readValue(jsonStr, TableVO.class);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return tableVO;
    }

    @Override
    public TableVO NewTable(TableVO tableVO) {


        SessionFactory sessionFactory = entityManagerFactory.unwrap(SessionFactory.class);
        StandardServiceRegistry serviceRegistry = sessionFactory.getSessionFactoryOptions().getServiceRegistry();
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        sessionFactory.getSessionFactoryOptions();
        List<ColumnVO> dataList = tableVO.getDataList();

        String XML_MAPPING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + tableVO.getModelName() + "\" table=\"" + tableVO.getModelName() + "\">\n";

        XML_MAPPING += " <id name=\"id\" type=\"java.lang.Long\" length=\"64\" unsaved-value=\"null\">\n" +
                "            <generator class=\"identity\" />\n" +
                "        </id>";
        for (ColumnVO columnVO : dataList) {
            XML_MAPPING +=
                    " <property type=\"" + columnVO.getFiledType() + "\" name=\"" + columnVO.getFieldName() +
                            "\" column=\"" + columnVO.getFieldName() + "\"/>\n";

        }

        XML_MAPPING += "    </class>" +
                "</hibernate-mapping>";


        metadataSources.addInputStream(new ByteArrayInputStream(XML_MAPPING.getBytes()));
        Metadata metadata = metadataSources.buildMetadata();
        //更新数据库Schema,如果不存在就创建表,存在就更新字段,不会影响已有数据
        SchemaUpdate schemaUpdate = new SchemaUpdate();
        schemaUpdate.execute(EnumSet.of(TargetType.DATABASE), metadata, serviceRegistry);

        metadata = metadataSources.buildMetadata();
        //创建会话工厂
        SessionFactory newSessionFactory = metadata.buildSessionFactory();
        //保存对象
        Session newSession = newSessionFactory.openSession();


//            Map<String, Object> entity = new HashMap<>();
//        for (ColumnVO columnVO : dataList) {
//           entity.put( columnVO.getFieldName(),"2222");
//        }
//            newSession.save(tableVO.getModuleName(), entity);
        cacheMap.put("tableName", tableVO.getModelName());
        cacheMap.put("xml", XML_MAPPING);

        TableInfo tableInfo = new TableInfo();

        tableInfo.setName(tableVO.getModelName());
        tableInfo.setCnName(tableVO.getModelTitle());

        tableInfo.setXML(XML_MAPPING);

        tableInfoDao.save(tableInfo);

        for (ColumnVO columnVO : dataList) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setName(columnVO.getFieldName());
            columnInfo.setType(columnVO.getFiledType());
            columnInfo.setLength(columnVO.getFiledLength());
            columnInfo.setCnName(columnVO.getFiledDescription());
            columnInfo.setDbName(tableInfo.getCnName());
            columnInfo.setDbId(tableInfo.getId());
            columnInfoDao.save(columnInfo);

        }

        //关闭会话
        newSession.close();
        return tableVO;
    }

    @Override
    public int putValueByEntityName(Map<String, Object> map) {
        for (String tableName:
             map.keySet()) {
            //查找对应的表
            Specification spec = (Specification) (root, criteriaQuery, criteriaBuilder) -> {

                Predicate equal = null;
                if (StringUtils.isEmpty("Name")) {
                    Path name = root.get("Name");
                    equal = criteriaBuilder.equal(name, tableName);
                }
                return equal;
            };
            Optional one = tableInfoDao.findOne(spec);
            TableInfo tableInfo = null;
            if (one.isPresent()){
                tableInfo = (TableInfo) one.get();
            }

            Object values = map.get(tableName);
            if (values instanceof Map){
                //插入数据
                insertValue(tableInfo.getName(),tableInfo.getXML(), (Map) values);
            }else {
                //循环插入数据
                List valuesList = (List) values;
                for (int i = 0; i < valuesList.size(); i++) {
                    insertValue(tableInfo.getName(),tableInfo.getXML(), (Map) valuesList.get(i));
                }
            }
        }
        return 0;
    }

    public void insertValue(String tableName,String xml,Map map){
        SessionFactory sessionFactory = entityManagerFactory.unwrap(SessionFactory.class);
        StandardServiceRegistry serviceRegistry = sessionFactory.getSessionFactoryOptions().getServiceRegistry();
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        sessionFactory.getSessionFactoryOptions();
        metadataSources.addInputStream(new ByteArrayInputStream(xml.getBytes()));
        Metadata metadata = metadataSources.buildMetadata();
        //更新数据库Schema,如果不存在就创建表,存在就更新字段,不会影响已有数据
        SchemaUpdate schemaUpdate = new SchemaUpdate();
        schemaUpdate.execute(EnumSet.of(TargetType.DATABASE), metadata, serviceRegistry);
        metadata = metadataSources.buildMetadata();
        //创建会话工厂
        SessionFactory newSessionFactory = metadata.buildSessionFactory();
        //保存对象
        Session newSession = newSessionFactory.openSession();
        newSession.saveOrUpdate(tableName,map);
    }
}
