package com.tykj.workflowcore.model_layer.entity;


import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import javax.persistence.Entity;
import java.io.Serializable;

/**
 * @ClassName TableInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:05
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Entity
@EntityListeners(AuditingEntityListener.class)
@Data
@SQLDelete(sql = "update table_info set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
public class TableInfo extends BaseEntity implements Serializable {


    @ApiModelProperty("表名，不能为空")
    @Column(nullable = false)
    private String name;
    @ApiModelProperty("表中文名，不能为空")
    @Column(nullable = false)
    private String cnName;

    @ApiModelProperty("详细描述")
    private String description;

    /**
     *0是扫描，1是自建
     */
    @ApiModelProperty("建表类型")
    private Integer type;

    @ApiModelProperty("执行人（保留字段）")
    private String reviser;
    @ApiModelProperty("父表名称")
    private String parentTable;

    @Lob
    @ApiModelProperty("表对应hbm.xml")
    private String xml;



}
