package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.entity.vo.SearchFlowInfoVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.VariableStorageVo;
import com.tykj.workflowcore.workflow_editer.service.*;
import com.tykj.workflowcore.workflow_editer.entity.vo.FlowsInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.FileNotFoundException;


/**
 * ClassName:    FlowsInfoController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/2/24   10:13
 * @Author: zsp
 */
@RestController
@Api("流程管理接口")
@RequestMapping("/flowsInfo")
public class FlowsInfoController {

    @Autowired
    private FlowInfoService flowInfoService;

    @Autowired
    private WorkFlowService workFlowService;

    @Autowired
    private NodeInfoService nodeInfoService;

    @Autowired
    private VariableStorageService variableStorageService;


    @PostMapping("/searchFlowInfo")
    @ApiOperation(value = "查询流程信息")
    public ResponseEntity searchFlowInfo(@RequestBody SearchFlowInfoVo searchFlowInfoVo){
        Page<FlowsInfo> flowsInfoList = flowInfoService.searchFlowInfo(searchFlowInfoVo);
        return ResultUtil.success(flowsInfoList,"查询成功");
    }

    @GetMapping("editFlow")
    @ApiOperation(value = "编辑流程")
    public String editFlow(Integer id){
        return  flowInfoService.editFlow(id).getFilePath();
    }
    @GetMapping("/deploy")
    @ApiOperation(value = "部署流程",notes = "部署成功")
    public ResponseEntity deploy(Integer id) throws FileNotFoundException {
        //根据id 查询出flowsInfo
        FlowsInfo flowsInfo = flowInfoService.findById(id);
        if (flowsInfo.getState() == 0){
            return ResultUtil.success(flowsInfo.getState(),"该流程已经被部署");
        }
        workFlowService.deployXml(flowsInfo);
        return ResultUtil.success(flowsInfo.getState(),"流程部署成功");
    }


    @PostMapping("/saveXml")
    @ApiOperation(value = "保存xml以及其他流程信息")
    public ResponseEntity saveXml(@RequestBody FlowsInfoVo flowsInfoVo) {
        //保存节点信息
        nodeInfoService.saveNodeInfoList(flowsInfoVo.getNodeInfoList());
        //保存xml信息
        workFlowService.flowXml(flowsInfoVo);
        return ResultUtil.success("文件保存成功");
    }

    @PostMapping("/updateByProcessName")
    @ApiOperation(value = "通过流程名称修改")
    public ResponseEntity updateByProcessName(@RequestBody FlowsInfoVo flowsInfoVo) {
        FlowsInfo flowsInfo = flowInfoService.findByFlowName(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowName(),"流程修改成功");
    }

    @PostMapping("/updateByDesc")
    @ApiOperation(value = "通过流程描述修改")
    public ResponseEntity updateByDesc(@RequestBody FlowsInfoVo flowsInfoVo) {
        FlowsInfo flowsInfo = flowInfoService.findByDesc(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowDescribe(),"流程修改成功");
    }

    @PostMapping("/createFlow")
    @ApiModelProperty("创建流程")
    public ResponseEntity createFlow(@RequestBody FlowsInfoVo flowsInfovo){
        return ResultUtil.success(workFlowService.createFlow(flowsInfovo.toEntity()),"流程创建成功");
    }

    @PostMapping("/saveVariableStorage")
    @ApiModelProperty("保存函数调用配置")
    public ResponseEntity saveVariableStorage(@RequestBody VariableStorageVo variableStorageVo){
        VariableStorage variableStorage = variableStorageService.saveVariableStorageService(variableStorageVo.toEntity());
        return ResultUtil.success(variableStorage,"调用接口成功");
    }

}
