package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.mapper.VariableStorageMapper;
import com.tykj.workflowcore.workflow_editer.service.VariableStorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName:    VariableStorageServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   10:13
 *
 * @Author: zsp
 */
@Service
public class VariableStorageServiceImpl implements VariableStorageService {
    @Autowired
    private VariableStorageMapper variableStorageMapper;

    @Override
    public VariableStorage saveVariableStorageService(@RequestBody VariableStorage variableStorage) {
        return variableStorageMapper.save(variableStorage);
    }

    @Override
    public List<VariableStorage> findByFlowKey(String flowKey) {
        List<VariableStorage> allByFlowKey = variableStorageMapper.findAllByFlowKey(flowKey);
        return allByFlowKey;
    }


}
