package com.tykj.workflowcore.model_layer.model;


import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotatiion.WorkFlowCoreNoScan;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.UpdateTimestamp;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * @ClassName TableInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:05
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "table_info")
@Data
public class TableInfo extends BaseEntity implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private long id;
    @ApiModelProperty("表名，不能为空")
    @Column(nullable = false)
    private String name;
    @ApiModelProperty("表中文名，不能为空")
    @Column(nullable = false)
    private String cnName;

    @ApiModelProperty("详细描述")
    private String description;

    /**
     *0是扫描，1是自建
     */
    @ApiModelProperty("建表类型")
    private Integer type;

    @ApiModelProperty("执行人保留字段")
    private String reviser;

    @Lob
    @ApiModelProperty("表对应hbm.xml")
    private String xml;



}
