package com.tykj.workflowcore.model_layer.utils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Entity;
import java.lang.reflect.Field;

/**
 * @ClassName JugdeSwagger
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 9:53
 * @Version 1.0
 */
public class SwaggerUtil {

    public static void Swagger(Class<?> aClass) {
        if (aClass.isAnnotationPresent(Entity.class)) {
            if (aClass.isAnnotationPresent(ApiModel.class)) {
                ApiModel annotation = aClass.getAnnotation(ApiModel.class);
                StringBuilder APiModelDocument = new StringBuilder();
                if (annotation.value() != null && !annotation.value().equals("")) {
                    APiModelDocument.append(aClass + "的文档：value=" + annotation.value().toString() + ".");
                }
                if (annotation.description() != null && !annotation.description().equals("")) {
                    APiModelDocument.append("description=" + annotation.description().toString() + ".");
                }
                System.out.println(APiModelDocument.toString());
            }
            Field[] declaredFields = aClass.getDeclaredFields();
            for (Field declaredField : declaredFields) {
                if (declaredField.isAnnotationPresent(ApiModelProperty.class)) {
                    ApiModelProperty annotation = declaredField.getAnnotation(ApiModelProperty.class);
                    StringBuilder ApiModelPropertyDocument = new StringBuilder();
                    if (annotation.value() != null && !annotation.value().equals("")) {
//                        System.out.println(declaredField+"的文档是"+annotation.value());
                        ApiModelPropertyDocument.append(declaredField + "的文档：value=" + annotation.value() + ".");
                    }
                    if (annotation.example() != null && !annotation.example().equals("")) {
//                        System.out.println(declaredField+"的文档是"+annotation.value());
                        ApiModelPropertyDocument.append("example=" + annotation.example() + ".");
                    }
                    System.out.println(ApiModelPropertyDocument.toString());
                }
            }
        }
    }

    public static boolean isSwagger(Class<?> aClass) {
        if (aClass.isAnnotationPresent(Entity.class)) {
            if (aClass.isAnnotationPresent(ApiModel.class)) {
                return true;
            }
        }
        return false;
    }
}
