package com.tykj.workflowcore.model_layer.controller;


import com.tykj.workflowcore.model_layer.model.ColumnInfo;
import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.model_layer.model.TableVO;
import com.tykj.workflowcore.model_layer.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelController
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:35
 * @Version 1.0
 */
@RestController
@RequestMapping("/model")
public class ModelController {
    @Autowired
    private ModelService modelService;

    @Autowired
    private ClassLoader classLoader;
/**
* @Author WWW
* @Description 得到所有数据库信息
* @Date 16:19 2021/3/4
* @param
* @return java.util.List<com.tykj.workflowcore.model_layer.model.TableInfo>
**/
    @RequestMapping("/getAllEntity")
    public List<TableInfo> getAllEntity() {

        List<TableInfo> tableInfos = null;
        try {
            tableInfos = modelService.ListAllEntities();
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }

        return tableInfos;
    }
/**
* @Author WWW
* @Description 根据表名得到所有字段名
* @Date 16:20 2021/3/4
* @param tableName
* @return java.util.List<com.tykj.workflowcore.model_layer.model.ColumnInfo>
**/
    @GetMapping("/getAllField")
    public List<ColumnInfo>  getFields(String tableName) {
        if (tableName!=null&&tableName!=""){
         return   modelService.showModelFields(tableName);
        }
        return null;
    }
/**
* @Author WWW
* @Description  新增数据模型
* @Date 16:21 2021/3/4
* @param
* @return org.springframework.http.ResponseEntity
**/
    @PostMapping("/addModel")
    //入参使用VO直接接收即可
    //jsonStr -> TableVo
    public ResponseEntity addModel(@RequestBody TableVO tableVO) throws Exception {
        List<TableInfo> tableInfos = modelService.ListAllEntities();
        for (TableInfo tableInfo : tableInfos) {
            if (tableVO.getModelName().equals(tableInfo.getName())){
                return new ResponseEntity(HttpStatus.BAD_GATEWAY);
            }
        }
        modelService.NewTable(tableVO);

        return new ResponseEntity(HttpStatus.OK);

    }
    /**
    * @Author WWW
    * @Description 对应表插入数据
     * map （表名，字段数据）
    * @Date 16:22 2021/3/4
    * @param map
    * @return int
    **/
    @PostMapping("/insertValues")
    public int insertValues(@RequestBody Map<String,Object> map){
        int i = modelService.putValueByEntityName(map);
        return i;

    }

    @GetMapping("/getPackge")
    public String testPack(){
        String name = this.getClass().getPackage().getName();
        return name;
    }
}
