package com.tykj.workflowcore.workflow_editer.entity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.ArrayList;
import java.util.List;

/**
 * ClassName:    PageEntity
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/3/3   10:51
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Api("页面实体关系")
public class PageEntity {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("页面Id")
    private Long pageId;

    @ApiModelProperty("实体类Id")
    private String entityId;
}
