package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.workflow_editer.entity.PageEntity;
import com.tykj.workflowcore.workflow_editer.mapper.PageEntityMapper;
import com.tykj.workflowcore.workflow_editer.service.PageEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName:    PageEntityServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/4   9:55
 *
 * @Author: zsp
 */
@Service
public class PageEntityServiceImpl implements PageEntityService {

    @Autowired
    private PageEntityMapper pageEntityMapper;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Override
    public void savePageEntity(PageEntity pageEntity) {
        pageEntityMapper.save(pageEntity);
    }

    @Override
    public List<TableInfo> findByPageIds(List<Integer> pageIds) {
        ArrayList<TableInfo> list = new ArrayList<>();
        for (Integer pageId : pageIds) {
            Long entityId = pageEntityMapper.findByPageId(pageId).getEntityId();
            //根据entityId查询出实体类
            TableInfo tableInfo = tableInfoDao.findById(entityId).get();
            list.add(tableInfo);
        }
        return list;
    }
}
