package com.tykj.workflowcore.model_layer.controller;


import com.tykj.workflowcore.model_layer.dao.ColumnInfoDao;
import com.tykj.workflowcore.model_layer.model.ColumnInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @ClassName ColumnController
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 14:33
 * @Version 1.0
 */
@RestController
@RequestMapping("/Column")
public class ColumnController {

    @Autowired
    private ColumnInfoDao columnInfoDao;

    @PostMapping("/addColumnInfo")
    public ColumnInfo addColumnInfo(@RequestBody ColumnInfo columnInfo) {

        ColumnInfo save = columnInfoDao.save(columnInfo);
        if (save != null) {
            return save;
        }
        return null;
    }

    @GetMapping("/getInfo")
    public List<ColumnInfo> getAll() {
        List<ColumnInfo> all = columnInfoDao.findAll();
        return all;
    }

    @GetMapping("/getInfo/{id}")
    public ColumnInfo getOne(@PathVariable("id") long id) {
        ColumnInfo one = columnInfoDao.findById(id).get();
        return one;
    }



}
