package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.entity.FormPage;
import com.tykj.service.FormPageService;
import com.tykj.vo.FormPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * ClassName:    FormPageController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/3   13:40
 *
 * @Author: zsp
 */
@RestController("/formPage")
@RequestMapping
@Api("页面管理接口")
public class FormPageController {

    @Autowired
    private FormPageService formPageService;

    @ApiOperation("保存页面")
    @PostMapping("/savePage")
    public Long savePage(@RequestBody FormPage formPage){
        return  formPageService.savePage(formPage);
    }

    @ApiOperation("回显页面")
    @GetMapping("/EchoPage/{id}")
    public FormPageVo EchoPage(@PathVariable("id") Long id){
        return  formPageService.getPage(id);
    }

    @ApiOperation("查看页面")
    @GetMapping("/findPages")
    public List<FormPageVo> findPages(){
        return  formPageService.getAllPages();
    }

    @ApiOperation("删除页面")
    @DeleteMapping("deletePage/{id}")
    public void deletePage(@PathVariable("id") Long id){
        formPageService.deletePage(id);
    }

}
