package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.entity.FormPage;
import com.tykj.mapper.FormPageMapper;
import com.tykj.service.FormPageService;
import com.tykj.vo.FormPageVo;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName:    PageEntityServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   13:16
 *
 * @Author: zsp
 */
@Service
public class FormPageServiceImpl implements FormPageService {

    @Autowired
    private FormPageMapper formPageMapper;

    @Override
    public Long savePage(@RequestBody FormPage formPage) {
        FormPage formPage1 = formPageMapper.save(formPage);
        Long id = formPage1.getId();
        return id;
    }

    @Override
    public FormPageVo getPage(@PathVariable("id") Long id) {

        FormPage formPage = formPageMapper.findById(id).get();
        ModelMapper modelMapper = new ModelMapper();
        FormPageVo formPageVo = modelMapper.map(formPage, FormPageVo.class);
        return formPageVo;
    }

    @Override
    public void deletePage(@PathVariable("id") Long id) {
        formPageMapper.deleteById(id);
    }

    @Override
    public List<FormPageVo> getAllPages() {

        ModelMapper modelMapper = new ModelMapper();
        ArrayList<FormPageVo> formPageVos = new ArrayList<>();
        List<FormPage> formPages = formPageMapper.findAll();
        for (FormPage formPage : formPages) {
            FormPageVo formPageVo = modelMapper.map(formPage, FormPageVo.class);
            formPageVos.add(formPageVo);
        }
        return formPageVos;
    }


}
