package com.tykj.workflowcore.workflow_editer.vo;

import com.tykj.entity.NodePage;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * ClassName:    FlowInfoVo
 * Package:    com.tykj.vo
 * Description:
 * Datetime:    2021/3/1   9:54
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FlowsInfoVo {
    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("发起人的名字")
    private Long userName;

    @ApiModelProperty("流程名称")
    private String flowName;

    @ApiModelProperty("流程主键")
    private String flowKey;

    @ApiModelProperty(value = "部署状态",notes = "0 已部署，1 未部署")
    private Integer state;

    @ApiModelProperty("流程创建时间")
    private Date createTime;

    @ApiModelProperty("流程修改时间")
    private Date updateTime;

    @ApiModelProperty("流程描述")
    private String flowDescribe;

    @ApiModelProperty
    private String fileXml;

    @ApiModelProperty("开始节点的id")
    private String startId;

    @ApiModelProperty()
    private List<NodePage> nodePages;
}
