package com.tykj.workflowcore.model_layer.utils;

import com.tykj.workflowcore.model_layer.model.QueryCondition;

import java.util.List;
import java.util.Objects;

/**
 * @author HASEE
 */
public class HqlUtil {

    public static String createQuery(String tableName, List<QueryCondition> conditions) {
        StringBuilder result = new StringBuilder("select entity from ");
        result.append(tableName).append(" entity ");
        if (Objects.nonNull(conditions) && !conditions.isEmpty()) {
            result.append(" where ");
            for (QueryCondition condition : conditions) {
                result.append("entity.")
                        .append(condition.getName())
                        .append(condition.getType())
                        .append(condition.getValue())
                        .append(" and ");
            }
            result.delete(result.lastIndexOf(" and "), result.length());
        }
        return result.toString();
    }

}
