package com.tykj.workflowcore.workflow_editer.entity;

import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

/**
 * ClassName:    VariablesMap
 * Package:    com.example.flowable.expense.controller
 * Description:
 * Datetime:    2021/3/10   19:08
 *
 * @Author: zsp
 */

public class VariablesMap implements Command<Object> {

    private String processInstanceId;

    private Expression expression;

    public VariablesMap(String processInstanceId, Expression expression) {
        this.processInstanceId = processInstanceId;
        this.expression = expression;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        ExecutionEntity executionEntity =
                executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId).get(0);

        return expression.getValue(executionEntity);
    }
}
